
# Q1 Iteration‑4 Runner (V2‑compliant)

This bundle contains a single Python script that reproduces the Iteration‑4 gravitational‑interferometer simulation using **boolean/ordinal** gating only (no curve weights). It generates three CSVs plus a manifest and audit.

## Requirements
- Python 3.9+
- Packages: `numpy`, `pandas` (no network access needed)

## Files
- `q1_iter4_run.py` — main simulation script
- Outputs (after running):
  - `q1_struct_port_bias.csv` — bias at fixed δt=0, per condition and seed
  - `q1_struct_peak_offsets.csv` — pre‑centered peak scans (±0.25), seed 101
  - `q1_struct_deltaT_unwrapped.csv` — raw and fractional ΔT per condition
  - `q1_struct_manifest.json` — recorded configuration
  - `q1_struct_audit.json` — guardrail audit (boolean acceptance; PF/Born only at ties)

## How to Run
```bash
python q1_iter4_run.py
```

The defaults implement:
- Lx=509 (prime), Ly=481, screen_col=508
- Vertical bands with per‑band **integer** micro‑act increments `{+5s, +9s, +13s, +17s}` added to base `M` (no weights)
- Instrument: jitter half‑width `J=0.15` (uniform), co‑fit window `ε=0.10`, Θ=1.0
- M=24; strictness s ∈ {0,1,2,3}; Δh ∈ {10,15}; y0=−15; seeds={101,202,303}
- Slant OFF by default. To also run slanted bands, edit `slant_list=[0,1]` in the `CONFIG` block of the script.

## Notes
- Time is computed as integer **micro‑act count / M (ticks)**.
- The recombiner uses **two boolean modular windows**; **PF/Born** is applied only when **both** ports pass.
- With narrow jitter the instrument becomes **phase‑sensitive** at δt=0 and reveals the structural phase via port bias.
